<?php // BEGIN PHP
$websitekey=basename(__DIR__); if (empty($websitepagefile)) $websitepagefile=__FILE__;
if (! defined('USEDOLIBARRSERVER') && ! defined('USEDOLIBARREDITOR')) {
	$pathdepth = count(explode('/', $_SERVER['SCRIPT_NAME'])) - 2;
	require_once ($pathdepth ? str_repeat('../', $pathdepth) : './').'master.inc.php';
} // Not already loaded
require_once DOL_DOCUMENT_ROOT.'/core/lib/website.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/website.inc.php';
ob_start();
// END PHP ?>
<html lang="en">
<head>
<title>Footer</title>
<meta charset="utf-8">
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="robots" content="index, follow" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="keywords" content="" />
<meta name="title" content="Footer" />
<meta name="description" content="" />
<meta name="generator" content="Dolibarr 17.0.0-beta (https://www.dolibarr.org)" />
<meta name="dolibarr:pageid" content="252" />
<?php if ($website->use_manifest) { print '<link rel="manifest" href="/manifest.json.php" />'."\n"; } ?>
<!-- Include link to CSS file -->
<link rel="stylesheet" href="/styles.css.php?website=<?php echo $websitekey; ?>" type="text/css" />
<!-- Include link to JS file -->
<script async src="/javascript.js.php"></script>
<!-- Include HTML header from common file -->
<?php if (file_exists(DOL_DATA_ROOT."/website/".$websitekey."/htmlheader.html")) include DOL_DATA_ROOT."/website/".$websitekey."/htmlheader.html"; ?>
<!-- Include HTML header from page header block -->

</head>
<!-- File generated by Dolibarr website module editor -->
<body id="bodywebsite" class="bodywebsite bodywebpage-footer">
<!-- Enter here your HTML content. Add a section with an id tag and tag contenteditable="true" if you want to use the inline editor for the content  -->
<section id="footer" contenteditable="true">
            <!-- Footer -->
        <footer class="site-footer section-padding">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-7 col-xs-12 tooplate-mt30">
                        <h6 class="text-white mb-lg-4 mb-3"><?php echo $weblangs->trans("Location"); ?></h6>

                        <p><?php echo $mysoc->getFullAddress(); ?></p>

                        <a href="contact.php#divaddress" class="custom-btn btn btn-dark mt-2"><?php echo $weblangs->trans("Map"); ?></a>
                    </div>

                    <div class="col-lg-4 col-md-5 col-xs-12 tooplate-mt30">
                        <h6 class="text-white mb-lg-4 mb-3">Opening Hours</h6>

         
                        <?php $days = ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY"];
                        foreach ($days as $day){
                            echo "<p> $day : " .getDolGlobalString("MAIN_INFO_OPENINGHOURS_$day")  ."</p>";    
                        }
                        ?>

                        <p>
                            Tel:
                            <a href="tel: <?php echo $mysoc->phone ?>" class="tel-link"
                                ><?php echo $mysoc->phone ?></a
                            >
                        </p>
                    </div>

                    <div class="col-lg-4 col-md-6 col-xs-12 tooplate-mt30">
                        <h6 class="text-white mb-lg-4 mb-3">Social</h6>

                        <ul class="social-icon">
                             <?php foreach($mysoc->socialnetworks as $key => $value) {
                                print '<li> <a class="btn btn-perso2 btn-floating m-1" href="'. (preg_match('/^http/', $value) ? $value : 'https://www.'.$key.'.com/'.$value).'"><span class="fab fa-'.$key.'"></i></a> </li>';
                             } ?>

                       
                        </ul>

                        <p class="copyright-text tooplate-mt60">
                            Copyright © <?php echo $mysoc->name; ?>
                        </p>
                    </div>
                </div>
                <!-- row ending -->
            </div>
            <!-- container ending -->
        </footer>
</section>

</body>
</html>
<?php // BEGIN PHP
$tmp = ob_get_contents(); ob_end_clean(); dolWebsiteOutput($tmp, "html", 252);
// END PHP ?>
